<?php
/*
Plugin Name: Link Widget
Description: Add a Simple Link Button
Version: 1
License: GPL
Author: Bayshore Solutions
Author URI: http://www.bayshoresolutions.com/
*/

class BSS_widget_linkbttn extends WP_Widget {

	function __construct() {
		$widget_ops = array('classname' => 'widget_linkbttn', 'description' => __('Add a Simple Link Button'), 'panels_icon' => 'bss-icon','panels_groups' => array('bayshorewidgets'));
		$control_ops = array('width' => 400, 'height' => 350);
		parent::__construct('cta', __('Link Button'), $widget_ops, $control_ops);
	}

	function widget( $args, $instance ) {
		extract($args);
		$text = apply_filters( 'widget_text', empty( $instance['text'] ) ? '' : $instance['text'], $instance, $this->id_base );
    	$linkurl = apply_filters( 'widget_linkurl', empty( $instance['linkurl'] ) ? '' : $instance['linkurl'], $instance, $this->id_base );
		$newwindow = apply_filters( 'widget_newwindow', empty( $instance['newwindow'] ) ? '' : $instance['newwindow'], $instance, $this->id_base );
		$bttntype = apply_filters( 'widget_bttntype', empty( $instance['bttntype'] ) ? '' : $instance['bttntype'], $instance, $this->id_base );
		$bttnalign = apply_filters( 'widget_bttnalign', empty( $instance['bttnalign'] ) ? '' : $instance['bttnalign'], $instance, $this->id_base );
		$bttnspacing = apply_filters( 'widget_bttnspacing', empty( $instance['bttnspacing'] ) ? '' : $instance['bttnspacing'], $instance, $this->id_base );
		echo $before_widget; ?>

	<div style="text-align:<?php echo $bttnalign; ?>;" class="<?php echo $bttnspacing; ?>">
		<a target="<?php echo $newwindow; ?>" href="<?php echo $linkurl; ?>" class="bttn <?php echo $bttntype; ?>">
			<?php if (!empty($text)) {?><?php echo $text; ?><?php } ?>
		</a>
	</div>	
		<?php
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['text'] = strip_tags($new_instance['text']);
    	$instance['linkurl'] = strip_tags($new_instance['linkurl']);
		$instance['newwindow'] = strip_tags($new_instance['newwindow']);
		$instance['bttntype'] = strip_tags($new_instance['bttntype']);
		$instance['bttnalign'] = strip_tags($new_instance['bttnalign']);
		$instance['bttnspacing'] = strip_tags($new_instance['bttnspacing']);
		$instance['filter'] = isset($new_instance['filter']);
		return $instance;
	}

	function form( $instance ) {
		$instance = wp_parse_args( (array) $instance, array( 'text' => '', 'linkurl' => '', 'newwindow' => '', 'bttntype' => '', 'bttnalign' => '', 'bttnspacing' => '') );
		$text = strip_tags($instance['text']);
		$linkurl = strip_tags($instance['linkurl']);
		$newwindow = strip_tags($instance['newwindow']);
    	$bttntype = strip_tags($instance['bttntype']);
    	$bttnalign = strip_tags($instance['bttnalign']);
		$linkurl = strip_tags($instance['linkurl']);
		$bttnspacing = strip_tags($instance['bttnspacing']);
?>
    
	<p>
		<label for="<?php echo $this->get_field_id('text'); ?>"><?php _e('Button Text:'); ?></label>
		<input class="widefat"  id="<?php echo $this->get_field_id('text'); ?>" name="<?php echo $this->get_field_name('text'); ?>" type="text" value="<?php echo $text; ?>" />
	</p>
    <p>
    	<label for="<?php echo $this->get_field_id('linkurl'); ?>"><?php _e('Link Path:'); ?></label>
    	<input class="widefat" id="<?php echo $this->get_field_id('linkurl'); ?>" name="<?php echo $this->get_field_name('linkurl'); ?>" type="text" value="<?php echo $linkurl; ?>" />
		<a href="#" class="button-secondary link-btn">Add Link</a>
    </p>
    <p>
		<label for="<?php echo $this->get_field_id('newwindow'); ?>"><?php _e('Link Target:'); ?></label>
		<select id="<?php echo $this->get_field_id('newwindow'); ?>" name="<?php echo $this->get_field_name('newwindow'); ?>">
			<option value="_self" <?php if ($newwindow == "_self") echo 'selected'; ?>>Default</option>
			<option value="_blank" <?php if ($newwindow == "_blank") echo 'selected'; ?>>New Window</option>
		</select>
    </p>
    <p><label for="<?php echo $this->get_field_id('bttntype'); ?>"><?php _e('Button Style:'); ?></label>
		<select id="<?php echo $this->get_field_id('bttntype'); ?>" name="<?php echo $this->get_field_name('bttntype'); ?>">
			<option value="" <?php if ($bttntype == "") echo 'selected'; ?>>Solid Red</option>
			<option value="white" <?php if ($bttntype == "white") echo 'selected'; ?>>Solid White</option>
			<option value="transparentred" <?php if ($bttntype == "transparentred") echo 'selected'; ?>>Transparent Red</option>
			<option value="transparentwhite" <?php if ($bttntype == "transparentwhite") echo 'selected'; ?>>Transparent White</option>
			<option value="redunderline" <?php if ($bttntype == "redunderline") echo 'selected'; ?>>Red Text with Underline</option>
		</select>
	</p>
	<p><label for="<?php echo $this->get_field_id('bttnalign'); ?>"><?php _e('Button Alignment:'); ?></label>
		<select id="<?php echo $this->get_field_id('bttnalign'); ?>" name="<?php echo $this->get_field_name('bttnalign'); ?>">
			<option value="left" <?php if ($bttnalign == "left") echo 'selected'; ?>>Left</option>
			<option value="center" <?php if ($bttnalign == "center") echo 'selected'; ?>>Center</option>
			<option value="right" <?php if ($bttnalign == "right") echo 'selected'; ?>>Right</option>
		</select>
	</p>
	<p><label for="<?php echo $this->get_field_id('bttnspacing'); ?>"><?php _e('Button Spacing:'); ?></label>
		<select id="<?php echo $this->get_field_id('bttnspacing'); ?>" name="<?php echo $this->get_field_name('bttnspacing'); ?>">
			<option value="spacing" <?php if ($bttnspacing == "spacing") echo 'selected'; ?>>Spacing</option>
			<option value="nospacing" <?php if ($bttnspacing == "nospacing") echo 'selected'; ?>>No Spacing</option>
		</select>
		<small style="display:block;">Toggle Spacing Above Button</small>
	</p>
	<script>
		jQuery(document).ready(function($){
			$('body').on('click', '.link-btn', function(event) {
				//wpActiveEditor = true; //we need to override this var as the link dialogue is expecting an actual wp_editor instance
				$(this).prev('input').addClass('url_input');
				wpLink.open(); //open the link popup
				event.stopPropagation();
				return false;
			});
			$('body').on('click', '#wp-link-submit', function(event) {
				var linkAtts = wpLink.getAttrs();
				$('.url_input').val(linkAtts.href);
				$('.url_input').removeClass('url_input');
				wpLink.textarea = $('body');
				wpLink.close();
				event.preventDefault ? event.preventDefault() : event.returnValue = false;
				event.stopPropagation();
				return false;
			});
			$('body').on('click', '#wp-link-cancel, #wp-link-close', function(event) {
				$('.url_input').removeClass('url_input');
				wpLink.textarea = $('body');
				wpLink.close();
				event.preventDefault ? event.preventDefault() : event.returnValue = false;
				event.stopPropagation();
				return false;
			});
		});
	
	</script>
		<?php
		
		} 
		}


add_action( 'widgets_init', function(){
	register_widget( "BSS_widget_linkbttn" );
});


?>